<?php
/**
 * Manages Enqueues of scripts and styles
 *
 * @category Core
 * @package  OxyProps
 * @author   Cédric Bontems <cedric@thewebforge.dev>
 * @license  https://www.gnu.org/licenses/gpl-2.0.html  GPL v2 or later
 * @link     https://oxyprops.com                       OxyProps Website
 * @since    1.5.0
 */

namespace OxyProps\Inc;

/**
 * Common code for creating Singleton classes
 * Code simplification
 */
trait Singleton {

	/**
	 * Singleton trait to be consumed by Singleton classes
	 *
	 * @since 1.5.0 Creation.
	 * @since 1.5.1 Removed explicit return type on __clone() to avoid errors.
	 * @author Cédric Bontems <contact@oxyprops.com>
	 *
	 * @var object
	 */
	protected static $instance = null;

	/** Call this method to get instance */
	final public static function get_instance(): object {
		if ( null === static::$instance ) {
			static::$instance = new static();
		}
		return static::$instance;
	}

	/** Protected to prevent cloning */
	protected function __clone() {
	}

	/** Protected to prevent instantiation from outside of the class */
	protected function __construct() {
		if ( (bool) class_parents( $this ) ) {
			parent::__construct();
		}

		$this->register();
	}

	/** Called at construct */
	protected function register() {
	}


}
